/*
 * Decompiled with CFR 0.152.
 */
package mcjty.deepresonance.modules.machines.block;

import mcjty.deepresonance.modules.core.CoreModule;
import mcjty.deepresonance.modules.core.block.ResonatingCrystalBlock;
import mcjty.deepresonance.modules.core.block.ResonatingCrystalTileEntity;
import mcjty.deepresonance.modules.machines.MachinesModule;
import mcjty.deepresonance.modules.machines.util.config.CrystallizerConfig;
import mcjty.deepresonance.util.LiquidCrystalData;
import mcjty.lib.api.container.DefaultContainerProvider;
import mcjty.lib.blocks.BaseBlock;
import mcjty.lib.blocks.RotationType;
import mcjty.lib.builder.BlockBuilder;
import mcjty.lib.builder.InfoLine;
import mcjty.lib.builder.TooltipBuilder;
import mcjty.lib.container.ContainerFactory;
import mcjty.lib.container.GenericItemHandler;
import mcjty.lib.container.SlotDefinition;
import mcjty.lib.tileentity.Cap;
import mcjty.lib.tileentity.CapType;
import mcjty.lib.tileentity.GenericEnergyStorage;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.tileentity.TickingTileEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class CrystallizerTileEntity
extends TickingTileEntity {
    public static final int SLOT = 0;
    public static final Lazy<ContainerFactory> CONTAINER_FACTORY = Lazy.of(() -> new ContainerFactory(1).slot(SlotDefinition.generic().out(), 0, 64, 24).playerSlots(10, 70));
    @Cap(type=CapType.ITEMS_AUTOMATION)
    private final GenericItemHandler items = GenericItemHandler.create((GenericTileEntity)this, CONTAINER_FACTORY).itemValid((integer, stack) -> stack.m_41720_() == CoreModule.RESONATING_CRYSTAL_GENERATED_ITEM.get()).insertable(GenericItemHandler.no()).extractable(GenericItemHandler.yes()).build();
    @Cap(type=CapType.ENERGY)
    private final GenericEnergyStorage energyStorage = new GenericEnergyStorage((GenericTileEntity)this, true, (long)((Integer)CrystallizerConfig.POWER_MAXIMUM.get()).intValue(), (long)((Integer)CrystallizerConfig.POWER_PER_TICK_IN.get()).intValue());
    @Cap(type=CapType.CONTAINER)
    private final LazyOptional<MenuProvider> screenHandler = LazyOptional.of(() -> new DefaultContainerProvider("Crystalizer").containerSupplier(DefaultContainerProvider.container(MachinesModule.CRYSTALIZER_CONTAINER, CONTAINER_FACTORY, (GenericTileEntity)this)).itemHandler(() -> this.items).energyHandler(() -> this.energyStorage).setupSync((GenericTileEntity)this));
    private int progress = 0;
    private LiquidCrystalData crystalData;
    private LazyOptional<IFluidHandler> rclTank;
    private int tankCooldown = 0;

    public CrystallizerTileEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)MachinesModule.TYPE_CRYSTALIZER.get(), pos, state);
    }

    public static BaseBlock createBlock() {
        return new BaseBlock(new BlockBuilder().tileEntitySupplier(CrystallizerTileEntity::new).info(new InfoLine[]{TooltipBuilder.key((String)"message.deepresonance.shiftmessage")}).infoShift(new InfoLine[]{TooltipBuilder.header()})){

            public RotationType getRotationType() {
                return RotationType.HORIZROTATION;
            }
        };
    }

    public void tickServer() {
        int newProgress;
        if (!this.canCrystallize()) {
            return;
        }
        this.energyStorage.consumeEnergy((long)((Integer)CrystallizerConfig.POWER_PER_TICK.get()).intValue());
        int rclPerCrystal = CrystallizerTileEntity.getRclPerCrystal();
        int drain = (Integer)CrystallizerConfig.RCL_PER_TICK.get();
        if (this.crystalData != null) {
            drain = Math.min(drain, rclPerCrystal - this.crystalData.getAmount());
        }
        if (drain > 0) {
            FluidStack stack = ((IFluidHandler)this.rclTank.orElseThrow(NullPointerException::new)).drain(drain, IFluidHandler.FluidAction.EXECUTE);
            LiquidCrystalData data = LiquidCrystalData.fromStack(stack);
            if (this.crystalData == null) {
                this.crystalData = data;
            } else {
                this.crystalData.merge(data);
            }
        }
        if (this.crystalData != null && this.crystalData.getAmount() >= rclPerCrystal) {
            ResonatingCrystalTileEntity crystal = new ResonatingCrystalTileEntity(this.f_58858_, ((ResonatingCrystalBlock)((Object)CoreModule.RESONATING_CRYSTAL_GENERATED.get())).m_49966_());
            crystal.setEfficiency(this.crystalData.getEfficiency() * 100.0);
            crystal.setPurity(this.crystalData.getPurity() * 100.0);
            crystal.setStrength(this.crystalData.getStrength() * 100.0);
            crystal.setPower(100.0);
            this.crystalData = null;
            this.items.setStackInSlot(0, ((ResonatingCrystalBlock)((Object)CoreModule.RESONATING_CRYSTAL_GENERATED.get())).createStack(crystal));
            this.m_6596_();
        }
        int n = newProgress = this.crystalData == null ? 0 : (int)((float)this.crystalData.getAmount() / (float)CrystallizerTileEntity.getRclPerCrystal() * 100.0f);
        if (this.progress != newProgress) {
            this.progress = newProgress;
            this.markDirtyClient();
        }
    }

    public int getMaxPower() {
        return this.energyStorage.getMaxEnergyStored();
    }

    public int getCurrentPower() {
        return this.energyStorage.getEnergyStored();
    }

    private boolean canCrystallize() {
        if (this.tankCooldown > 0) {
            --this.tankCooldown;
        }
        if (!(this.rclTank != null && this.rclTank.isPresent() || this.checkTank())) {
            return false;
        }
        if (this.energyStorage.getEnergyStored() < (Integer)CrystallizerConfig.POWER_PER_TICK.get()) {
            return false;
        }
        if (this.hasCrystal()) {
            return false;
        }
        FluidStack fluidStack = ((IFluidHandler)this.rclTank.orElseThrow(NullPointerException::new)).drain(((Integer)CrystallizerConfig.RCL_PER_TICK.get()).intValue(), IFluidHandler.FluidAction.SIMULATE);
        if (fluidStack.isEmpty() || fluidStack.getAmount() < 1) {
            return false;
        }
        return LiquidCrystalData.isValidLiquidCrystalStack(fluidStack);
    }

    private boolean checkTank() {
        this.rclTank = null;
        if (this.tankCooldown <= 0) {
            this.tankCooldown = 21;
            BlockEntity tile = this.f_58857_.m_7702_(this.f_58858_.m_7495_());
            if (tile != null) {
                this.rclTank = tile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY);
                return this.rclTank.isPresent();
            }
        }
        return false;
    }

    public boolean hasCrystal() {
        return !this.items.getStackInSlot(0).m_41619_();
    }

    protected void saveInfo(CompoundTag tagCompound) {
        super.saveInfo(tagCompound);
        CompoundTag info = this.getOrCreateInfo(tagCompound);
        if (this.crystalData != null) {
            CompoundTag tag = new CompoundTag();
            this.crystalData.getFluidStack().writeToNBT(tag);
            info.m_128365_("crystalData", (Tag)tag);
        }
        info.m_128405_("progress", this.progress);
    }

    public void saveClientDataToNBT(CompoundTag tagCompound) {
        tagCompound.m_128405_("progress", this.progress);
    }

    public void loadInfo(CompoundTag tagCompound) {
        super.loadInfo(tagCompound);
        CompoundTag info = tagCompound.m_128469_("Info");
        this.crystalData = info.m_128441_("crystalData") ? LiquidCrystalData.fromStack(FluidStack.loadFluidStackFromNBT((CompoundTag)info.m_128469_("crystalData"))) : null;
        this.progress = info.m_128451_("progress");
    }

    public void loadClientDataFromNBT(CompoundTag tagCompound) {
        this.progress = tagCompound.m_128451_("progress");
    }

    private static int getRclPerCrystal() {
        return (Integer)CrystallizerConfig.RCL_PER_CRYSTAL.get();
    }

    public AABB getRenderBoundingBox() {
        return new AABB((double)(this.m_58899_().m_123341_() - 10), (double)(this.m_58899_().m_123342_() - 10), (double)(this.m_58899_().m_123343_() - 10), (double)(this.m_58899_().m_123341_() + 10), (double)(this.m_58899_().m_123342_() + 10), (double)(this.m_58899_().m_123343_() + 10));
    }

    public int getProgress() {
        return this.progress;
    }
}

